# Прокси для Docker Swarm

Docker Flow Proxy - простой и удобный прокси сервер (HAProxy), который автоматически переконфигурируется при создании/удалении новых сервисов.

Запускает сервисы:

1. **[Docker Flow Proxy](https://github.com/vfarcic/docker-flow-proxy)** - обрабатывает запросы, приходящие на хост на порты 80 и 443 + генерирует конфиг.
1. **[Docker Flow Swarm Listener](https://github.com/vfarcic/docker-flow-swarm-listener)** - следит за запуском/остановкой контейнеров на кластере, запускает (пере-)создание конфигов.

## Начало работы

### Как развернуть стек

1. Создать сеть `proxy` на кластере и задеплоить данный стек:

```bash
docker network create --driver overlay proxy
docker stack deploy -c proxy.yml proxy
```

Для дополнительной конфигурации можно указать переменные окржения:

- `DF_PROXY_VER` - Версия образа [Docker Flow Proxy](https://github.com/vfarcic/docker-flow-proxy)
- `DF_SWARM_LISTENER_VER` - Версия образа [Docker Flow Swarm Listener](https://github.com/vfarcic/docker-flow-swarm-listener)
- `CONNECTION_MODE` - режим соединения, по-умолчанию http-keep-alive

### Как подключить проект к прокси

В конфиге проекта `docker-compose.yml` указать внешнюю сеть `proxy`:

```yml
networks:
  proxy:
    external: true
```

Для контейнера с веб-сервером (nginx, apache, etc) необходимо указать сети:

```yml
networks:
  - default
  - proxy
```

`default` - чтобы для доступа к контейнерам в сети проекта
`proxy` - для участия в прокси

А также в зоне `deploy` указать лейблы:

```yml
deploy:
  replicas: 1
  labels:
    - com.df.notify=true
    - com.df.distribute=true
    - com.df.serviceDomain=domain.com
    - com.df.servicePath=/
    - com.df.srcPort=80
    - com.df.port=8000
```

Пример выше будет обрабатывать **http** запросы (порт 80) с домена **domain.com** в сервис с порта *8000* по пути `/`.

Подробнее о лейблах для [Docker Flow Proxy](http://proxy.dockerflow.com/usage/#general-http-query-parameters)

## Let's Encrypt

Для автоматической генерации SSL-сертификатов через Let's Encrypt, можно использовать решение [`hamburml/docker-flow-letsencrypt`](https://github.com/hamburml/docker-flow-letsencrypt)

### Пример использования

```bash
CERTBOT_EMAIL=1119@zolotoykod.ru DOMAIN_1=('demo.zolotoykod.ru') docker stack deploy -c letsencrypt.yml letsencrypt
```

- `DF_LE_VER` - Версия `hamburml/docker-flow-letsencrypt`, по-умолчанию `0.1.5`
- `VOLUME_DRIVER` - драйвер тома под хранение сертификатов, по-умолчанию `vsphere`
- `DOMAIN_1` - домены, для которых генерировать сертификаты
- `CERTBOT_EMAIL` - email для certbot